/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.connection.provider;

import com.mulesoft.connectors.mqtt3.api.FailOverURL;
import com.mulesoft.connectors.mqtt3.api.Protocol;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3ConnectionProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="fail-over")
@DisplayName(value="MQTT3 Fail-Over Connection")
@ExternalLib(name="Eclipse Paho MQTT3", description="Eclipse Paho MQTT3 client library for MQTT v3", nameRegexpMatcher="(.*)\\.jar", coordinates="org.eclipse.paho:org.eclipse.paho.client.mqttv3:1.2.5", type=ExternalLibraryType.JAR, optional=true)
public class MQTT3FailOverConnectionProvider
extends MQTT3ConnectionProvider {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The list of server URLs to iterate over until a connection to the broker is successfully established")
    private List<FailOverURL> failOverServers = Collections.emptyList();

    public List<FailOverURL> getFailOverServers() {
        return this.failOverServers;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.failOverServers.isEmpty()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No failOver servers have been specified. At least one mqtt server must be listed."), (Initialisable)this);
        }
        if (this.failOverServers.stream().filter(failOverURL -> failOverURL.getUrl().startsWith(Protocol.SSL.name()) || failOverURL.getUrl().startsWith(Protocol.WSS.name())).count() > 0L && this.tlsContextFactory == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Secure protocols were specified but no tls context was provided for " + this.failOverServers.stream().filter(failOverURL -> failOverURL.getUrl().startsWith(Protocol.SSL.name()) || failOverURL.getUrl().startsWith(Protocol.WSS.name())))), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        super.initialise();
    }

    @Override
    protected void configureMqttConnectOptions(MQTT3Connection mqtt3Connection) throws ConnectionException {
        String[] failOverServerArray = new String[this.failOverServers.size()];
        for (int i = 0; i < this.failOverServers.size(); ++i) {
            failOverServerArray[i] = this.failOverServers.get(i).getUrl();
        }
        mqtt3Connection.setFailOverServers(failOverServerArray);
    }

    @Override
    protected String getUrl() {
        return this.getFailOverServers().isEmpty() ? "" : this.getFailOverServers().get(0).getUrl();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTT3FailOverConnectionProvider)) {
            return false;
        }
        MQTT3FailOverConnectionProvider that = (MQTT3FailOverConnectionProvider)o;
        return super.equals(that) && this.failOverServers.equals(that.failOverServers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientIDGenerator, this.username, this.password, this.tlsContextFactory, this.lastWillAndTestament, this.connectionOptions, this.failOverServers);
    }
}

