/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.connection.provider;

import com.mulesoft.connectors.mqtt3.api.Protocol;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3ConnectionProvider;
import java.util.Objects;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="MQTT3 URL Connection")
@ExternalLib(name="Eclipse Paho MQTT3", description="Eclipse Paho MQTT3 client library for MQTT v3", nameRegexpMatcher="(.*)\\.jar", coordinates="org.eclipse.paho:org.eclipse.paho.client.mqttv3:1.2.5", type=ExternalLibraryType.JAR, optional=true)
public class MQTT3UrlConnectionProvider
extends MQTT3ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTT3UrlConnectionProvider.class);
    @Url
    @Parameter
    @Example(value="tcp://0.0.0.0:1883")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="URL")
    @Summary(value="The url to connect to")
    private String url;

    @Override
    protected void configureMqttConnectOptions(MQTT3Connection mqtt3Connection) throws ConnectionException {
    }

    @Override
    protected String getUrl() {
        return this.url;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            if ((this.url.startsWith(Protocol.SSL.name()) || this.url.startsWith(Protocol.WSS.name())) && this.tlsContextFactory == null) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Secure protocol was specified but no tls context was provided " + this.url)), (Initialisable)this);
            }
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        }
        catch (InitialisationException exception) {
            LOGGER.error("Failed to initialise TLS context. " + exception.getMessage(), (Throwable)exception);
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Failed to initialise TLS context. " + exception.getMessage()), (Object[])new Object[]{exception}), (Initialisable)this);
        }
        super.initialise();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTT3ConnectionProvider)) {
            return false;
        }
        MQTT3UrlConnectionProvider that = (MQTT3UrlConnectionProvider)o;
        return super.equals(that) && this.url.equals(that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientIDGenerator, this.username, this.password, this.tlsContextFactory, this.lastWillAndTestament, this.connectionOptions, this.url);
    }
}

