/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mule.runtime.api.connection.ConnectionException;

public class MQTT3ConnectionExceptionResolver {
    private static final List<Short> connectionErrorCodes = Arrays.asList((short)32104, (short)32103, (short)32109, (short)32111);

    public static Optional<ConnectionException> resolveMQTT3ConnectionException(Throwable throwable, Object conn) {
        MqttException mqttException;
        Optional<ConnectionException> exception = Optional.empty();
        if (throwable instanceof MqttException && connectionErrorCodes.contains((mqttException = (MqttException)throwable).getReasonCode())) {
            exception = Optional.of(new ConnectionException(throwable, conn));
        }
        return exception;
    }
}

