/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.operation;

import com.mulesoft.connectors.mqtt3.api.QoS;
import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3PublishErrorTypes;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.annotation.param.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT3Operations {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTT3Operations.class);

    @Throws(value={MQTT3PublishErrorTypes.class})
    @MediaType(value="*/*")
    public void publish(String topic, @Connection MQTT3Connection connection, @Content InputStream message, @Optional(defaultValue="AT_LEAST_ONCE") QoS qos, boolean isRetained, CompletionCallback<Void, Void> completionCallback) {
        try {
            CompletableFuture<Integer> future = connection.publish(topic, IOUtils.toByteArray((InputStream)message), qos.getValue(), isRetained);
            future.whenComplete((messageId, mqttError) -> {
                if (mqttError == null) {
                    LOGGER.debug("Message with id " + messageId + " successfully published");
                    completionCallback.success(null);
                } else {
                    completionCallback.error(mqttError);
                }
            });
        }
        catch (Throwable mqttException) {
            completionCallback.error(mqttException);
        }
    }
}

