/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

import com.mulesoft.connectors.mqtt3.api.QoS;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.param.display.Text;

public class LWTMessage {
    @Optional
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The topic to which the last will and testament message will be published")
    private String topic;
    @Text
    @Optional
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The content of the last will and testament message")
    private String body;
    @Parameter
    @Optional(defaultValue="AT_LEAST_ONCE")
    @DisplayName(value="QoS")
    @Summary(value="The quality of service for the last will and testament message publish")
    private QoS qos;
    @Optional
    @Parameter
    @Summary(value="Whether the last will and testament message should be retained by the broker")
    private boolean isRetained;

    public String getTopic() {
        return this.topic;
    }

    public String getBody() {
        return this.body;
    }

    public QoS getQoS() {
        return this.qos;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LWTMessage that = (LWTMessage)o;
        return this.isRetained == that.isRetained && Objects.equals(this.topic, that.topic) && Objects.equals(this.body, that.body) && this.qos == that.qos;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topic, this.body, this.qos, this.isRetained});
    }
}

