/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.api;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class MQTT3MessageAttributes
implements Serializable {
    private static final long serialVersionUID = 4913835689071707740L;
    @Parameter
    private String topic;
    @Parameter
    private int messageId;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int qos;
    @Parameter
    private boolean isDuplicate;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean isRetained;

    private MQTT3MessageAttributes(String topic, int id, int qos, boolean isDuplicate, boolean isRetained) {
        this.topic = topic;
        this.messageId = id;
        this.qos = qos;
        this.isDuplicate = isDuplicate;
        this.isRetained = isRetained;
    }

    public MQTT3MessageAttributes() {
    }

    public String getTopic() {
        return this.topic;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MQTT3MessageAttributes otherAttr = (MQTT3MessageAttributes)o;
        return new EqualsBuilder().append((Object)this.topic, (Object)otherAttr.topic).append(this.messageId, otherAttr.messageId).append(this.qos, otherAttr.qos).append(this.isRetained, otherAttr.isRetained).append(this.isDuplicate, otherAttr.isDuplicate).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.messageId, this.qos, this.isRetained, this.isDuplicate);
    }

    public static class Builder {
        private String topic;
        private int messageId;
        private int qos;
        private boolean duplicate;
        private boolean isRetained;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder withQoS(int qos) {
            this.qos = qos;
            return this;
        }

        public Builder withMessageId(int id) {
            this.messageId = id;
            return this;
        }

        public Builder withRetained(boolean isRetained) {
            this.isRetained = isRetained;
            return this;
        }

        public Builder withDuplicate(boolean isDuplicate) {
            this.duplicate = isDuplicate;
            return this;
        }

        public MQTT3MessageAttributes build() {
            return new MQTT3MessageAttributes(this.topic, this.messageId, this.qos, this.duplicate, this.isRetained);
        }
    }
}

