/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.api.clientId;

import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDGenerator;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3InvalidClientIDException;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Summary(value="Generates a client id from a static prefix and a dynamic suffix")
public class ClientIDCustomExpressionGenerator
implements ClientIDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIDCustomExpressionGenerator.class);
    @Parameter
    @DisplayName(value="Client ID")
    @Optional(defaultValue="")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ClientId
    @Summary(value="A static client id to identify the connection to the broker")
    protected String clientId;
    @Parameter
    @DisplayName(value="Custom Client ID Suffix")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="")
    @Summary(value="A dynamic client id suffix")
    protected String customClientIdSuffix;

    @Override
    public String generateClientID() {
        if (this.clientId.isEmpty() && this.customClientIdSuffix.isEmpty()) {
            LOGGER.error("A custom expression client id generator was used, but neither the 'Client ID' parameter nor the 'Custom Client ID Suffix' parameter has been specified.");
            throw new MQTT3InvalidClientIDException("A custom expression client id generator was used, but neither the 'Client ID' parameter nor the 'Custom Client ID Suffix' parameter has been specified.");
        }
        return this.clientId + this.customClientIdSuffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientIDCustomExpressionGenerator)) {
            return false;
        }
        ClientIDCustomExpressionGenerator that = (ClientIDCustomExpressionGenerator)o;
        return this.clientId.equals(that.clientId) && this.customClientIdSuffix.equals(that.customClientIdSuffix);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.customClientIdSuffix);
    }
}

