/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.connection;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class MQTT3ConnectionOptions {
    @Parameter
    @Optional(defaultValue="30")
    @Placement(tab="Advanced", order=1)
    @Summary(value="Socket connection timeout value")
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced", order=2)
    @Summary(value="Time unit to be used in the Timeout configurations")
    private TimeUnit timeoutUnit;
    @Parameter
    @Placement(tab="Advanced", order=3)
    @Optional(defaultValue="0")
    @Summary(value="The maximum amount of time for an inactive connection to be kept alive")
    private int keepAliveInterval;
    @Parameter
    @Placement(tab="Advanced", order=4)
    @Summary(value="Time unit to be used as unit for the 'keepAliveInterval' parameter")
    @Optional(defaultValue="SECONDS")
    private TimeUnit keepAliveIntervalUnit;
    @Parameter
    @Placement(tab="Advanced", order=5)
    @Optional(defaultValue="10")
    @Summary(value="The maximum amount of messages that can be unacknowledged at a given time")
    private int maxInFlight;
    @Parameter
    @Placement(tab="Advanced", order=6)
    @Optional(defaultValue="true")
    @Summary(value="Whether the session should be cleaned each time the client disconnects from the broker")
    private boolean cleanSession;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.timeoutUnit;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public TimeUnit getKeepAliveIntervalUnit() {
        return this.keepAliveIntervalUnit;
    }

    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    public boolean getCleanSession() {
        return this.cleanSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTT3ConnectionOptions)) {
            return false;
        }
        MQTT3ConnectionOptions otherConnectionOptions = (MQTT3ConnectionOptions)o;
        return new EqualsBuilder().append(this.keepAliveInterval, otherConnectionOptions.keepAliveInterval).append((Object)this.keepAliveIntervalUnit, (Object)otherConnectionOptions.keepAliveIntervalUnit).append(this.maxInFlight, otherConnectionOptions.maxInFlight).append(this.connectionTimeout, otherConnectionOptions.connectionTimeout).append((Object)this.timeoutUnit, (Object)otherConnectionOptions.timeoutUnit).append(this.cleanSession, otherConnectionOptions.cleanSession).isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keepAliveInterval, this.keepAliveIntervalUnit, this.maxInFlight, this.connectionTimeout, this.timeoutUnit, this.cleanSession});
    }
}

