/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.internal.connection;

import com.mulesoft.connectors.mqtt3.internal.connection.MQTT3Connection;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3ConnectionExceptionResolver;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3InvalidTopicException;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3PublishException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT3PublishActionListener
implements IMqttActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTT3PublishActionListener.class);
    private MQTT3Connection connection;
    private CompletableFuture<Integer> future;

    public MQTT3PublishActionListener(CompletableFuture<Integer> future, MQTT3Connection connection) {
        this.connection = connection;
        this.future = future;
    }

    public void onSuccess(IMqttToken iMqttToken) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully published message with MessageId: " + iMqttToken.getMessageId());
        }
        this.future.complete(iMqttToken.getMessageId());
    }

    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
        LOGGER.error("Exception found on message publish operation: " + throwable.getMessage(), throwable);
        Optional<ConnectionException> connException = MQTT3ConnectionExceptionResolver.resolveMQTT3ConnectionException(throwable, this.connection);
        if (connException.isPresent()) {
            this.future.completeExceptionally((Throwable)connException.get());
        } else if (throwable instanceof IllegalArgumentException) {
            this.future.completeExceptionally((Throwable)((Object)new MQTT3InvalidTopicException(throwable)));
        } else {
            this.future.completeExceptionally((Throwable)((Object)new MQTT3PublishException(throwable)));
        }
    }
}

