/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt3.api.clientId;

import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDGenerator;
import java.util.Objects;
import java.util.UUID;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.ClientId;

@Summary(value="Generates a client id from a static prefix and appends a random uuid suffix")
public class ClientIDRandomSuffixGenerator
implements ClientIDGenerator {
    @Parameter
    @DisplayName(value="Client ID")
    @Optional(defaultValue="")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ClientId
    @Summary(value="A static client id prefix to identify the connection to the broker")
    protected String clientId;
    private UUID randomSuffix = UUID.randomUUID();

    @Override
    public String generateClientID() {
        return this.clientId + (this.clientId.isEmpty() ? "" : "-") + this.randomSuffix;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientIDRandomSuffixGenerator)) {
            return false;
        }
        ClientIDRandomSuffixGenerator that = (ClientIDRandomSuffixGenerator)o;
        return this.clientId.equals(that.clientId) && this.randomSuffix.equals(that.randomSuffix);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.randomSuffix);
    }
}

