/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.api;

import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3FailOverConnectionProvider;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.connectivity.Port;

import static com.mulesoft.connectors.mqtt3.internal.utils.UrlResolver.resolveUrl;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Represents one of several URLs to be included in the connection
 * fail-over broker list in a {@link MQTT3FailOverConnectionProvider}.
 *
 * @since 1.0
 */
public class FailOverURL {

  /**
   * The protocol to be used when connecting to the broker.
   */
  @Parameter
  @Optional(defaultValue = "TCP")
  @Expression(value = NOT_SUPPORTED)
  @Summary("The connection's protocol")
  private Protocol protocol;

  /**
   * The host of the broker to connect to.
   */
  @Host
  @Parameter
  @Optional(defaultValue = "localhost")
  @Expression(value = NOT_SUPPORTED)
  @Summary("The host of the broker to connect to")
  private String host;

  /**
   * The broker's port to connect to.
   */
  @Port
  @Parameter
  @Optional(defaultValue = "1883")
  @Expression(value = NOT_SUPPORTED)
  @Summary("The broker's port to connect to")
  private String port;

  /**
   * @return this URL's {@link Protocol}
   */
  public Protocol getProtocol() {
    return protocol;
  }

  /**
   * @return this URL's host.
   */
  public String getHost() {
    return host;
  }

  /**
   * @return this URL's port.
   */
  public String getPort() {
    return port;
  }

  /**
   * @return this URL's connection string.
   */
  public String getUrl() {
    return resolveUrl(this);
  }
}
