/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.api;

/**
 * Declares the kind of protocol to be used to connect to the broker.
 *
 * There are five protocol options:
 *
 * <ul>
 * <li><b>TCP</b></li>
 * <li><b>SSL</b></li>
 * <li><b>WS</b></li>
 * <li><b>WSS</b></li>
 * <li><b>LOCAL</b></li>
 * </ul>
 *
 * @since 1.0
 */
public enum Protocol {

  /**
   * Deliver mqtt messages over TCP connection.
   */
  TCP("tcp"),
  /**
   * Deliver mqtt messages using WebSockets connection.
   */
  WS("ws"),
  /**
   * Deliver mqtt messages over Secure WebSockets connection.
   */
  WSS("wss"),
  /**
   * Deliver mqtt messages over SSL/TLS connection.
   */
  SSL("ssl"),
  /**
   * Deliver mqtt messages over local connection.
   */
  LOCAL("local");

  private String protocol;

  Protocol(String protocol) {
    this.protocol = protocol;
  }

  /**
   * @return the protocol's scheme.
   */
  public String getProtocol() {
    return protocol;
  }
}
