/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.api;

/**
 * Declares the quality of service to be used to publish or receive
 * mqtt messages.
 *
 * There are three quality of service levels:
 *
 * <ul>
 * <li><b>AT_MOST_ONCE</b></li>
 * <li><b>AT_LEAST_ONCE</b></li>
 * <li><b>EXACTLY_ONCE</b></li>
 * </ul>
 *
 * @since 1.0
 */
public enum QoS {

  /**
   * Fire and forget. No guarantees that the message will be delivered correctly.
   */
  AT_MOST_ONCE(0),

  /**
   * The message will be delivered at least one time. The message could be delivered more than once.
   */
  AT_LEAST_ONCE(1),

  /**
   * Guarantees that the message will be delivered exactly one time.
   */
  EXACTLY_ONCE(2);

  private int qos;

  QoS(int qos) {
    this.qos = qos;
  }

  /**
   * @return the quality of service level's numeric value.
   */
  public int getValue() {
    return qos;
  }
}
