/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.api;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.Objects;

/**
 * Represents an MQTT v3 topic.
 *
 * @since 1.0
 */
public class Topic {

  /**
   * A topic filter that can represent a single or multilevel subscription to a topic.
   */
  @Parameter
  @Summary("The topic filter to subscribe to")
  private String topicFilter;

  /**
   * The {@link QoS} with which messages (destined to this topic's topicFilter)
   * should be sent by the broker.
   * <p>
   * Defaults to {@code AT_LEAST_ONCE}
   */
  @Parameter
  @Optional(defaultValue = "AT_LEAST_ONCE")
  @DisplayName("QoS")
  @Summary("The quality of service for the subscription")
  private QoS qos;

  /**
   * @return the topic filter for this instance.
   */
  public String getTopicFilter() {
    return topicFilter;
  }

  /**
   * @return the {@link QoS} for this topic.
   */
  public QoS getQos() {
    return qos;
  }

  public void setTopicFilter(String topicFilter) {
    this.topicFilter = topicFilter;
  }

  public void setQos(QoS qos) {
    this.qos = qos;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (!(o instanceof Topic)) {
      return false;
    }

    Topic otherTopic = (Topic) o;
    return new EqualsBuilder().append(this.qos, otherTopic.qos).append(this.topicFilter, otherTopic.topicFilter).isEquals();
  }

  @Override
  public int hashCode() {
    return Objects.hash(topicFilter, qos);
  }
}
