/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.connection;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.Objects;

import static org.mule.runtime.api.meta.model.display.PathModel.Type.DIRECTORY;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;

/**
 * Represents the MQTT connector's file persistence settings for reliable messaging.
 *
 * @since 1.0
 */
public class MQTT3FilePersistenceOptions {

  /**
   * If set to true, creates an file-based persistent data store, used to store outbound and inbound messages
   * while they are in flight, enabling delivery to the QoS specified.
   */
  @Parameter
  @Placement(tab = ADVANCED_TAB, order = 7)
  @Optional(defaultValue = "false")
  @Summary("Whether a file-based persistent data store should be created to store in flight messages")
  private boolean enableFilePersistence;

  /**
   * The directory where the file-based persistent data store will be created
   * if enableFilePersistence is set to true.
   */
  @Parameter
  @Placement(tab = ADVANCED_TAB, order = 8)
  @Optional(defaultValue = "")
  @Path(type = DIRECTORY)
  @Summary("The directory where the file-based persistent data store will be created if enableFilePersistence is set to true.")
  private String dataStorePath;

  /**
   * @return the enableFilePersistence flag value.
   */
  public boolean getEnableFilePersistence() {
    return enableFilePersistence;
  }

  /**
   * @return the dataStorePath parameter value.
   */
  public String getDataStorePath() {
    return dataStorePath;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (!(o instanceof MQTT3FilePersistenceOptions)) {
      return false;
    }

    MQTT3FilePersistenceOptions filePersistenceOptions = (MQTT3FilePersistenceOptions) o;
    return new EqualsBuilder()
        .append(enableFilePersistence, filePersistenceOptions.enableFilePersistence)
        .append(dataStorePath, filePersistenceOptions.dataStorePath)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return Objects.hash(enableFilePersistence, dataStorePath);
  }
}
