/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.connection;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * Represents an action to be performed when a subscription action has been completed.
 */
public class MQTT3SubscriptionSuccessListener implements IMqttActionListener {

  private static final Logger LOGGER = getLogger(MQTT3SubscriptionSuccessListener.class);

  @Override
  public void onSuccess(IMqttToken asyncActionToken) {
    if (LOGGER.isDebugEnabled()) {
      LOGGER.debug("Successfully subscribed to topics: {}", asyncActionToken.getTopics());
    }
  }

  @Override
  public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
    LOGGER.error("Failed to subscribe to topics " + asyncActionToken.getTopics(), exception);
  }
}
