/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import com.mulesoft.connectors.mqtt3.internal.extension.MQTT3Connector;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 * Errors for the {@link MQTT3Connector}
 *
 * @since 1.0
 */
public enum MQTT3Error implements ErrorTypeDefinition<MQTT3Error> {

  /**
   * Error related to the connection.
   */
  CONNECTIVITY(MuleErrors.CONNECTIVITY),

  /**
   * Error during authentication with mqtt broker.
   */
  UNAUTHORIZED(MuleErrors.CLIENT_SECURITY),

  /**
   * Error generating the client id.
   */
  INVALID_CLIENT_ID,

  /**
   * Error publishing message to broker.
   */
  PUBLISH,

  /**
   * Error publishing message because socket threw write timeout.
   */
  WRITE_TIMEOUT(PUBLISH),

  /**
   * Error publishing message because an error occurred while reading/writing
   * persistent data for reliable messaging.
   */
  PERSISTENCE(PUBLISH),

  /**
   * Error publishing message because an invalid topic was provided.
   */
  INVALID_TOPIC(PUBLISH);

  private ErrorTypeDefinition<? extends Enum<?>> parent;

  MQTT3Error(ErrorTypeDefinition<? extends Enum<?>> parent) {
    this.parent = parent;
  }

  MQTT3Error() {}

  @Override
  public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
    return ofNullable(parent);
  }
}
