/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import org.mule.runtime.extension.api.exception.ModuleException;

import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.INVALID_CLIENT_ID;
import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

/**
 * A {@link ModuleException} for the cases in which an invalid client id is provided to identify a connection.
 */
public class MQTT3InvalidClientIDException extends ModuleException {

  /**
   * Returns an instance of {@link MQTT3InvalidClientIDException}.
   * @param message a message that specifies the reason why the client id is invalid.
   */
  public MQTT3InvalidClientIDException(String message) {
    super(createStaticMessage(message), INVALID_CLIENT_ID);
  }
}
