/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import org.mule.runtime.extension.api.exception.ModuleException;

import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.INVALID_TOPIC;

/**
 * A {@link ModuleException} for the cases in which an invalid topic is provided to publish a message.
 */
public class MQTT3InvalidTopicException extends ModuleException {

  /**
   * Returns an instance of {@link MQTT3InvalidTopicException}.
   * @param cause the original {@link Throwable} that was thrown.
   */
  public MQTT3InvalidTopicException(Throwable cause) {
    super(INVALID_TOPIC, cause);
  }
}
