/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import org.mule.runtime.extension.api.exception.ModuleException;

import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.PERSISTENCE;

/**
 * A {@link ModuleException} for the cases where an error occurred while reading/writing
 * persistent data for reliable messaging.
 */
public class MQTT3PersistenceException extends ModuleException {

  /**
   * Returns an instance of {@link MQTT3PersistenceException}
   * @param cause the original {@link Throwable} that was thrown.
   */
  public MQTT3PersistenceException(Throwable cause) {
    super(PERSISTENCE, cause);
  }
}
