/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.HashSet;
import java.util.Set;

import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.INVALID_TOPIC;
import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.PERSISTENCE;
import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.PUBLISH;
import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.UNAUTHORIZED;
import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.INVALID_CLIENT_ID;
import static com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error.WRITE_TIMEOUT;

/**
 * Defines the possible errors for the publish operation.
 *
 * @since 1.0
 */
public class MQTT3PublishErrorTypes implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    HashSet<ErrorTypeDefinition> errorTypeDefinitions = new HashSet<>();
    errorTypeDefinitions.add(PUBLISH);
    errorTypeDefinitions.add(INVALID_TOPIC);
    errorTypeDefinitions.add(PERSISTENCE);
    errorTypeDefinitions.add(WRITE_TIMEOUT);
    errorTypeDefinitions.add(UNAUTHORIZED); // Since the connection is now deferred, we need to add the UNAUTHORIZED error type
    errorTypeDefinitions.add(INVALID_CLIENT_ID); // Since the connection is now deferred, we need to add the INVALID_CLIENT_ID error type
    return errorTypeDefinitions;
  }
}
