/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.exceptions;

import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * A {@link ModuleException} for the cases in which an error arises while publishing a message to a topic.
 */
public class MQTT3PublishException extends ModuleException {

  /**
   * Returns an instance of {@link MQTT3PublishException}.
   * @param cause the original {@link Throwable} that was thrown.
   */
  public MQTT3PublishException(Throwable cause) {
    super(MQTT3Error.PUBLISH, cause);
  }
}
