/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.extension;

import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDCustomExpressionGenerator;
import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDGenerator;
import com.mulesoft.connectors.mqtt3.api.clientId.ClientIDRandomSuffixGenerator;
import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3FailOverConnectionProvider;
import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3FormConnectionProvider;
import com.mulesoft.connectors.mqtt3.internal.connection.provider.MQTT3UrlConnectionProvider;
import com.mulesoft.connectors.mqtt3.internal.exceptions.MQTT3Error;
import com.mulesoft.connectors.mqtt3.internal.operation.MQTT3Operations;
import com.mulesoft.connectors.mqtt3.internal.source.MQTT3MessageListener;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.sdk.api.annotation.JavaVersionSupport;

import static org.mule.runtime.api.meta.Category.SELECT;
import static org.mule.sdk.api.meta.JavaVersion.JAVA_8;
import static org.mule.sdk.api.meta.JavaVersion.JAVA_11;
import static org.mule.sdk.api.meta.JavaVersion.JAVA_17;


/**
 * MQTT3 is a MQTT v3 compliant MuleSoft Extension, used to consume and produce MQTT Messages. The Extension supports
 * all MQTT v3 functionality including message retention, last will and testament messages and persistent sessions.
 *
 * @since 1.0
 */
@Xml(prefix = "mqtt3")
@Extension(name = "MQTT3", category = SELECT)
@Operations(MQTT3Operations.class)
@ConnectionProviders({MQTT3FailOverConnectionProvider.class, MQTT3UrlConnectionProvider.class, MQTT3FormConnectionProvider.class})
@Sources(MQTT3MessageListener.class)
@ErrorTypes(MQTT3Error.class)
@RequiresEnterpriseLicense(allowEvaluationLicense = true)
@SubTypeMapping(baseType = ClientIDGenerator.class,
    subTypes = {ClientIDRandomSuffixGenerator.class, ClientIDCustomExpressionGenerator.class})
@JavaVersionSupport({JAVA_8, JAVA_11, JAVA_17})
public class MQTT3Connector {

}
