/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

/**
 * Represents the default implementation of an {@link MQTT3Message}.
 */
public class DefaultMQTT3Message implements MQTT3Message {

  private int id;
  private int qos;
  private boolean isRetained;
  private boolean isDuplicate;
  private String topic;
  private byte[] message;

  /**
   * Returns an instance of a {@link DefaultMQTT3Message}
   * @param id the message id.
   * @param topic the topic to which the message was published.
   * @param mqttMessage the message content.
   * @param qos the quality of service for this message.
   * @param isDuplicate whether this message could be a duplicate of one that was already received.
   * @param isRetained whether this message was set to be retained by the broker at the specified topic.
   */
  public DefaultMQTT3Message(int id, String topic, byte[] mqttMessage, int qos, boolean isDuplicate, boolean isRetained) {
    this.id = id;
    this.topic = topic;
    this.message = mqttMessage;
    this.qos = qos;
    this.isDuplicate = isDuplicate;
    this.isRetained = isRetained;
  }

  @Override
  public String getTopic() {
    return this.topic;
  }

  @Override
  public int getId() {
    return this.id;
  }

  @Override
  public int getQoS() {
    return this.qos;
  }

  @Override
  public boolean getIsRetained() {
    return this.isRetained;
  }

  @Override
  public boolean getIsDuplicate() {
    return this.isDuplicate;
  }

  @Override
  public byte[] getContent() {
    return this.message;
  }
}
