/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

import com.mulesoft.connectors.mqtt3.api.QoS;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;

import java.util.Objects;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Represents a last will and testament message.
 *
 * @since 1.0
 */
public class LWTMessage {

  /**
   * The topic to which the last will and testament message will be published.
   */
  @Optional
  @Parameter
  @Expression(NOT_SUPPORTED)
  @Summary("The topic to which the last will and testament message will be published")
  private String topic;

  /**
   * The content of the last will and testament message.
   */
  @Text
  @Optional
  @Parameter
  @Expression(NOT_SUPPORTED)
  @Summary("The content of the last will and testament message")
  private String body;

  /**
   * The quality of service {@ling QoS} with which the last will and testament message will be published.
   * <p>
   * Defaults to {@code AT_LEAST_ONCE}
   */
  @Parameter
  @Optional(defaultValue = "AT_LEAST_ONCE")
  @DisplayName("QoS")
  @Summary("The quality of service for the last will and testament message publish")
  private QoS qos;

  /**
   * If set to true the last will and testament message will be retained by the broker.
   */
  @Optional
  @Parameter
  @Summary("Whether the last will and testament message should be retained by the broker")
  private boolean isRetained;

  /**
   * @return the topic parameter value.
   */
  public String getTopic() {
    return topic;
  }

  /**
   * @return the body parameter value.
   */
  public String getBody() {
    return body;
  }

  /**
   * @return the qos parameter value.
   */
  public QoS getQoS() {
    return qos;
  }

  /**
   * @return the isRetained parameter value.
   */
  public boolean isRetained() {
    return isRetained;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LWTMessage that = (LWTMessage) o;
    return isRetained == that.isRetained && Objects.equals(topic, that.topic) && Objects.equals(body, that.body)
        && qos == that.qos;
  }

  @Override
  public int hashCode() {
    return Objects.hash(topic, body, qos, isRetained);
  }
}
