/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

/**
 * Represents an implementation of {@link MQTT3MessageHandler} that
 * will forward the message to the handler as soon as it has arrived.
 */
public class MQTT3ForwardingMessageHandler implements MQTT3MessageHandler {

  private MQTT3MessageHandler messageHandler;

  /**
   * Returns an instance of a {@link MQTT3ForwardingMessageHandler}
   * @param messageHandler the {@link MQTT3MessageHandler} to be invoked when an {@link MQTT3Message} arrives.
   */
  public MQTT3ForwardingMessageHandler(MQTT3MessageHandler messageHandler) {
    this.messageHandler = messageHandler;
  }

  @Override
  public void onMessageArrived(MQTT3Message mqttMessage) {
    if (messageHandler != null) {
      this.messageHandler.onMessageArrived(mqttMessage);
    }
  }
}
