/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

/**
 * Represents an mqtt message.
 *
 * @since 1.0
 */
public interface MQTT3Message {

  /**
   * @return the topic to which the message was originally published. This will only
   * be set for messages received from the broker.
   */
  String getTopic();

  /**
   * @return the message id.
   */
  int getId();

  /**
   * @return the quality of service for this message.
   */
  int getQoS();

  /**
   * @return true if the message should be/was retained by the broker.
   */
  boolean getIsRetained();

  /**
   * @return true if the message might be a duplicate of one which has already been received. This will only
   * be set for messages received from the broker.
   */
  boolean getIsDuplicate();

  byte[] getContent();

}
