/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

/**
 * Handles the event of an {@link MQTT3Message} being received.
 *
 * @since 1.0
 */
public interface MQTT3MessageHandler {

  /**
   * Handles the event of a message arrival.
   * @param mqttMessage the received {@link MQTT3Message}.
   */
  void onMessageArrived(MQTT3Message mqttMessage);
}
