/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.routing;

/**
 * Determines whether a specific topic name matches a topic filter.
 *
 * @since 1.0
 */
public interface MQTT3TopicMatcher {

  /**
   * @param topicFilter a topic filter.
   * @param topic a topic name.
   * @return true if the given topic matches the topic filter.
   */
  boolean topicMatches(String topicFilter, String topic);

}
