/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.source;

import com.mulesoft.connectors.mqtt3.api.MQTT3MessageAttributes;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Handles the event of a connection being lost.
 */
public class MQTT3ConnectionLostHandler {

  private final List<SourceCallback<byte[], MQTT3MessageAttributes>> sourceCallbacks;

  public MQTT3ConnectionLostHandler() {
    this.sourceCallbacks = new CopyOnWriteArrayList<>();
  }

  /**
   * Invoked when a connection that had been successfully established, is lost.
   * @param throwable the {@link Throwable} that was originally thrown when the connection was lost.
   * @param connection the {@link Object} needed to create a {@link ConnectionException}.
   */
  public void onConnectionLost(Throwable throwable, Object connection) {
    List<SourceCallback<byte[], MQTT3MessageAttributes>> callbacksCopy = new CopyOnWriteArrayList<>(sourceCallbacks);
    for (SourceCallback<byte[], MQTT3MessageAttributes> sourceCallback : callbacksCopy) {
      sourceCallback.onConnectionException(new ConnectionException(throwable, connection));
    }
  }

  public void addCallback(SourceCallback<byte[], MQTT3MessageAttributes> callback) {
    sourceCallbacks.add(callback);
  }

}
