/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.internal.utils;

import com.mulesoft.connectors.mqtt3.api.FailOverURL;

/**
 * Resolves a URL.
 */
public class UrlResolver {

  /**
   * @param failOverURL an instance of {@link FailOverURL}
   * @return the resolved URL string.
   */
  public static String resolveUrl(FailOverURL failOverURL) {
    return failOverURL.getProtocol().getProtocol() + "://" + failOverURL.getHost() + ":" + failOverURL.getPort();
  }

}
