/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
import java.io.IOException;

/**
 * Utility class for restarting, stopping, and starting Docker containers using command-line commands.
 */
public class DockerContainerRestarter {

  /**
   * Restarts a Docker container specified by its name or ID.
   *
   * @param containerNameOrId The name or ID of the Docker container to restart.
   * @throws IOException          If an I/O error occurs.
   * @throws InterruptedException If the thread is interrupted while waiting for the process to finish.
   */
  public static void restartDockerContainer(String containerNameOrId) throws IOException, InterruptedException {
    String dockerRestartCommand = "docker restart " + containerNameOrId;
    executeCommand(dockerRestartCommand, "Docker container restarted successfully", "Failed to restart Docker container");
  }

  /**
   * Stops a Docker container specified by its name or ID.
   *
   * @param containerNameOrId The name or ID of the Docker container to stop.
   * @throws IOException          If an I/O error occurs.
   * @throws InterruptedException If the thread is interrupted while waiting for the process to finish.
   */
  public static void stopDockerContainer(String containerNameOrId) throws IOException, InterruptedException {
    String dockerStopCommand = "docker stop " + containerNameOrId;
    executeCommand(dockerStopCommand, "Docker container stopped successfully", "Failed to stop Docker container");
  }

  /**
   * Starts a Docker container specified by its name or ID.
   *
   * @param containerNameOrId The name or ID of the Docker container to start.
   * @throws IOException          If an I/O error occurs.
   * @throws InterruptedException If the thread is interrupted while waiting for the process to finish.
   */
  public static void startDockerContainer(String containerNameOrId) throws IOException, InterruptedException {
    String dockerStartCommand = "docker start " + containerNameOrId;
    executeCommand(dockerStartCommand, "Docker container started successfully", "Failed to start Docker container");
  }

  private static void executeCommand(String command, String successMessage, String failureMessage)
      throws IOException, InterruptedException {
    ProcessBuilder processBuilder = new ProcessBuilder();
    processBuilder.command("bash", "-c", command);

    Process process = processBuilder.start();
    int exitCode = process.waitFor();

    if (exitCode == 0) {
      System.out.println(successMessage);
    } else {
      System.err.println(failureMessage);
    }
  }
}
