/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectors.mqtt3.api;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertTrue;

public class MQTT3MessageAttributesTest {

  @Test
  public void equalsTest() {
    MQTT3MessageAttributes mqtt3MessageAttributes = MQTT3MessageAttributes.Builder.newInstance().withMessageId(1234).withQoS(2)
        .withDuplicate(false).withTopic("aTopicName").build();

    assertTrue(mqtt3MessageAttributes.equals(mqtt3MessageAttributes));

    assertFalse(mqtt3MessageAttributes.equals(null));
    String anotherObjectType = "AnotherObject";
    assertFalse(mqtt3MessageAttributes.equals(anotherObjectType));

    MQTT3MessageAttributes mqtt3MessageAttributes1 = MQTT3MessageAttributes.Builder.newInstance().withMessageId(1234).withQoS(2)
        .withDuplicate(false).withTopic("aTopicName").build();

    assertTrue(mqtt3MessageAttributes.equals(mqtt3MessageAttributes1));
  }

  @Test
  public void hashCodeWithSameObject() {
    MQTT3MessageAttributes mqtt3MessageAttributes = MQTT3MessageAttributes.Builder.newInstance().withMessageId(1234).withQoS(2)
        .withDuplicate(false).withTopic("aTopicName").build();
    MQTT3MessageAttributes mqtt3MessageAttributes1 = MQTT3MessageAttributes.Builder.newInstance().withMessageId(1234).withQoS(2)
        .withDuplicate(false).withTopic("aTopicName").build();
    assertEquals(mqtt3MessageAttributes.hashCode(), mqtt3MessageAttributes1.hashCode());
  }

  @Test
  public void hashCodeWithDifferentObject() {
    MQTT3MessageAttributes mqtt3MessageAttributes = MQTT3MessageAttributes.Builder.newInstance().withMessageId(456).withQoS(0)
        .withDuplicate(false).withTopic("topicName").withRetained(false).build();
    MQTT3MessageAttributes mqtt3MessageAttributes1 = MQTT3MessageAttributes.Builder.newInstance().withMessageId(1234).withQoS(2)
        .withDuplicate(false).withTopic("aTopicName").build();
    assertNotEquals(mqtt3MessageAttributes.hashCode(), mqtt3MessageAttributes1.hashCode());
  }
}
