/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectors.mqtt3.api;

import org.junit.Test;

import static com.mulesoft.connectors.mqtt3.api.QoS.EXACTLY_ONCE;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class TopicTest {

  @Test
  public void equalsTest() {
    Topic topic = new Topic();
    assertTrue(topic.equals(topic));

    assertFalse(topic.equals(null));

    String differentTypeObject = "not a topic";
    assertFalse(topic.equals(differentTypeObject));

    Integer anotherDifferentType = 123;
    assertFalse(topic.equals(anotherDifferentType));

    Object genericObject = new Object();
    assertFalse(topic.equals(genericObject));

    Topic topic2 = new Topic();
    topic2.setTopicFilter("TopicFilter");
    topic2.setQos(EXACTLY_ONCE);
    Topic topic3 = new Topic();
    topic3.setTopicFilter("TopicFilter2");
    topic3.setQos(EXACTLY_ONCE);
    assertFalse(topic2.equals(topic3));

    Topic topic4 = new Topic();
    topic4.setTopicFilter("aTopicFilter");
    topic4.setQos(EXACTLY_ONCE);
    Topic topic5 = new Topic();
    topic5.setTopicFilter("aTopicFilter");
    topic5.setQos(EXACTLY_ONCE);
    assertTrue(topic5.equals(topic4));

  }
}
