/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectors.mqtt3.api.clientId;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

public class ClientIDRandomSuffixGeneratorTest {

  @Test
  public void generateSuffixWithClientIDIsEmpty() {
    ClientIDRandomSuffixGenerator suffixGenerator = new ClientIDRandomSuffixGenerator();
    suffixGenerator.setClientId("");
    String stgClientId = suffixGenerator.generateClientID();
    assertFalse(stgClientId.isEmpty());
  }

  @Test
  public void generateSuffixWithClientID() {
    ClientIDRandomSuffixGenerator suffixGenerator = new ClientIDRandomSuffixGenerator();
    suffixGenerator.setClientId("test");
    String stgClientId = suffixGenerator.generateClientID();
    assertTrue(stgClientId.contains("test"));
  }

  @Test
  public void equalsTest() {
    ClientIDRandomSuffixGenerator suffixGenerator = new ClientIDRandomSuffixGenerator();
    suffixGenerator.setClientId("test");
    assertTrue(suffixGenerator.equals(suffixGenerator));
    String anotherObject = "anotherObject";
    assertFalse(suffixGenerator.equals(anotherObject));
    ClientIDRandomSuffixGenerator randomSuffixGenerator = new ClientIDRandomSuffixGenerator();
    randomSuffixGenerator.setClientId("test");
    assertFalse(suffixGenerator.equals(randomSuffixGenerator));
    assertTrue(randomSuffixGenerator.generateClientID().contains(randomSuffixGenerator.getClientId()));
  }

  @Test
  public void hashCodeTest() {
    ClientIDRandomSuffixGenerator suffixGenerator = new ClientIDRandomSuffixGenerator();
    suffixGenerator.setClientId("test");

    assertEquals(suffixGenerator.hashCode(), suffixGenerator.hashCode());
  }
}
