/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.service;

import com.google.gson.JsonSyntaxException;
import com.mulesoft.connector.netsuite.extension.internal.config.NetSuiteRestletConfig;
import com.mulesoft.connector.netsuite.extension.internal.connection.NetSuiteAbstractRestletConnection;
import com.mulesoft.connector.netsuite.extension.internal.error.NetSuiteErrorType;
import com.mulesoft.connector.netsuite.extension.internal.error.exception.NetSuiteException;
import com.mulesoft.connector.netsuite.extension.internal.error.exception.NetsuiteRequestFailedException;
import com.mulesoft.connector.netsuite.extension.internal.service.RestletService;
import com.mulesoft.connector.netsuite.extension.internal.util.JsonWrapper;
import com.mulesoft.extensions.request.builder.RequestBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletServiceImpl
implements RestletService {
    private static final Logger logger = LoggerFactory.getLogger(RestletServiceImpl.class);
    private final JsonWrapper jsonWrapper;
    private final NetSuiteRestletConfig config;
    private final NetSuiteAbstractRestletConnection connection;

    public RestletServiceImpl(NetSuiteRestletConfig config, NetSuiteAbstractRestletConnection connection) {
        this.config = config;
        this.connection = connection;
        this.jsonWrapper = new JsonWrapper();
    }

    @Override
    public List<Map<String, Object>> get(Map<String, Object> data, int script, int deploy) {
        RequestBuilder request = this.connection.buildGetRequest(data, script, deploy);
        try {
            return this.toListFromString((String)(MapUtils.isEmpty(data) ? request : request.queryParams(new MultiMap(data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()))))).execute());
        }
        catch (IOException e) {
            throw new NetSuiteException(NetSuiteErrorType.MAPPING_ERROR, e);
        }
        catch (TimeoutException e) {
            throw new NetSuiteException(NetSuiteErrorType.CONNECTIVITY, e);
        }
        catch (NetsuiteRequestFailedException e) {
            throw new NetSuiteException(NetSuiteErrorType.ERROR_FAULT, (Throwable)((Object)e));
        }
    }

    @Override
    public List<Map<String, Object>> post(Map<String, Object> data, int script, int deploy) {
        try {
            return this.toListFromString((String)this.connection.buildPostRequest(data, script, deploy).execute());
        }
        catch (IOException e) {
            throw new NetSuiteException(NetSuiteErrorType.MAPPING_ERROR, e);
        }
        catch (TimeoutException e) {
            throw new NetSuiteException(NetSuiteErrorType.CONNECTIVITY, e);
        }
        catch (NetsuiteRequestFailedException e) {
            throw new NetSuiteException(NetSuiteErrorType.ERROR_FAULT, (Throwable)((Object)e));
        }
    }

    @Override
    public List<Map<String, Object>> put(Map<String, Object> data, int script, int deploy) {
        try {
            return this.toListFromString((String)this.connection.buildPutRequest(data, script, deploy).execute());
        }
        catch (IOException e) {
            throw new NetSuiteException(NetSuiteErrorType.MAPPING_ERROR, e);
        }
        catch (TimeoutException e) {
            throw new NetSuiteException(NetSuiteErrorType.CONNECTIVITY, e);
        }
        catch (NetsuiteRequestFailedException e) {
            throw new NetSuiteException(NetSuiteErrorType.ERROR_FAULT, (Throwable)((Object)e));
        }
    }

    @Override
    public void delete(Map<String, Object> data, int script, int deploy) {
        RequestBuilder<String> request = this.connection.buildDeleteRequest(data, script, deploy);
        if (!MapUtils.isEmpty(data)) {
            request.queryParams(new MultiMap(data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()))));
        }
        try {
            request.execute();
        }
        catch (IOException e) {
            throw new NetSuiteException(NetSuiteErrorType.MAPPING_ERROR, e);
        }
        catch (TimeoutException e) {
            throw new NetSuiteException(NetSuiteErrorType.CONNECTIVITY, e);
        }
        catch (NetsuiteRequestFailedException e) {
            throw new NetSuiteException(NetSuiteErrorType.ERROR_FAULT, (Throwable)((Object)e));
        }
    }

    private List<Map<String, Object>> toListFromString(String responseString) {
        try {
            return this.jsonWrapper.parseListMap(responseString);
        }
        catch (JsonSyntaxException e) {
            logger.info("Response was not a valid JSON. Trying to parse it as a String", (Throwable)e);
            try {
                return Collections.singletonList(Collections.singletonMap("result", this.jsonWrapper.parseString(responseString)));
            }
            catch (Exception ex) {
                throw new NetSuiteException("Unable to parse the response!", NetSuiteErrorType.PARSING_ERROR, ex);
            }
        }
    }
}

