/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.connection.provider.config;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AdvancedConfig {
    @Parameter
    @Optional
    @DisplayName(value="Web Service Endpoint")
    @Placement(tab="Advanced", order=1)
    private String endpoint;
    @Parameter
    @Optional(defaultValue="60000")
    @Placement(tab="Advanced", order=2)
    @Summary(value="The amount of time that the client will wait for a response before it times out.")
    private Integer readTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=3)
    @Summary(value="The time unit for Read Timeout.")
    private TimeUnit readTimeoutUnit;
    @Parameter
    @Optional(defaultValue="60000")
    @Placement(tab="Advanced", order=4)
    @Summary(value="The amount of time that the client will attempt to establish a connection before it times out. 0 specifies that the client will continue to attempt to open a connection indefinitely.")
    private Integer connectionTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=5)
    @Summary(value="The time unit for Connection Timeout.")
    private TimeUnit connectionTimeoutUnit;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    @Optional
    @DisplayName(value="TLS configuration")
    @Placement(tab="Security", order=1)
    private TlsContextFactory tlsContext;

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public Integer getConnectionTimeoutInMillis() {
        return Math.toIntExact(this.connectionTimeoutUnit.toMillis(this.connectionTimeout.intValue()));
    }

    public Integer getReadTimeoutInMillis() {
        return Math.toIntExact(this.readTimeoutUnit.toMillis(this.readTimeout.intValue()));
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

