/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.error.exception;

import com.mulesoft.extensions.request.builder.exception.RequestFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetsuiteRequestFailedException
extends RequestFailedException {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetsuiteRequestFailedException.class);
    private static final String MESSAGE = "[%s] - %s - body : %s ";

    public NetsuiteRequestFailedException(HttpResponse response) {
        super(response, String.format(MESSAGE, response.getStatusCode(), HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)response.getStatusCode()), NetsuiteRequestFailedException.createMessage(response)));
    }

    private static String createMessage(HttpResponse response) {
        String format = "";
        try {
            format = String.format(MESSAGE, response.getStatusCode(), HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)response.getStatusCode()), IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            return format;
        }
        catch (Exception e) {
            format = String.format(MESSAGE, response.getStatusCode(), HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)response.getStatusCode()), NetsuiteRequestFailedException.getEntityString(response));
            return format;
        }
    }

    private static String getEntityString(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioException) {
            LOGGER.debug(" Unable to transform the HTTP entity ", (Throwable)ioException);
            return "";
        }
    }
}

