/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.connection;

import com.google.common.net.UrlEscapers;
import com.mulesoft.connector.netsuite.extension.internal.connection.NetSuiteAbstractRestletConnection;
import com.mulesoft.connector.netsuite.extension.internal.connection.provider.config.TokenConnectionParameters;
import com.mulesoft.connector.netsuite.extension.internal.error.NetSuiteErrorType;
import com.mulesoft.connector.netsuite.extension.internal.error.exception.NetSuiteException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.MapUtils;
import org.mule.runtime.http.api.client.HttpClient;

public class NetSuiteTokenRestletConnection
extends NetSuiteAbstractRestletConnection {
    private final TokenConnectionParameters connectionParameters;
    private static final String UTF_8 = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private final Random random = new Random();

    public NetSuiteTokenRestletConnection(HttpClient httpClient, String endpoint, TokenConnectionParameters connectionParameters, Integer readTimeout) {
        super(endpoint, httpClient, readTimeout);
        this.connectionParameters = connectionParameters;
    }

    @Override
    public String generateAuthHeader(String httpMethod, int script, int deploy, Map<String, Object> data) {
        String signature;
        Long timestampLong = System.currentTimeMillis() / 1000L;
        String timestamp = String.valueOf(timestampLong);
        String nonce = NetSuiteTokenRestletConnection.generateNonceWithTimestamp(timestampLong);
        String macSignature = this.connectionParameters.getSignatureAlgorithm().contains("256") ? HMAC_SHA256 : HMAC_SHA1;
        String[] splittedUrl = this.getEndpoint().split("\\?");
        try {
            TreeMap<String, String> paramsMap = new TreeMap<String, String>();
            paramsMap.put("script", String.valueOf(script));
            paramsMap.put("deploy", String.valueOf(deploy));
            if (!MapUtils.isEmpty(data)) {
                paramsMap.putAll(new HashMap<String, String>(data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()))));
            }
            paramsMap.put("oauth_consumer_key", this.connectionParameters.getConsumerKey());
            paramsMap.put("oauth_nonce", nonce);
            paramsMap.put("oauth_signature_method", this.connectionParameters.getSignatureAlgorithm());
            paramsMap.put("oauth_timestamp", timestamp);
            paramsMap.put("oauth_token", this.connectionParameters.getTokenId());
            paramsMap.put("oauth_version", "1.0");
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry2 : paramsMap.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(this.isDate((String)entry2.getValue()) ? this.encode((String)entry2.getKey()) : UrlEscapers.urlFragmentEscaper().escape((String)entry2.getKey()));
                stringBuilder.append("=");
                stringBuilder.append(this.isDate((String)entry2.getValue()) ? this.encode((String)entry2.getValue()) : UrlEscapers.urlFragmentEscaper().escape((String)entry2.getValue()));
            }
            String macKey = this.encode(this.connectionParameters.getConsumerSecret()) + "&" + this.encode(this.connectionParameters.getTokenSecret());
            String fullEncodedUrl = this.encode(httpMethod) + "&" + this.encode(splittedUrl[0]) + "&" + this.encode(stringBuilder.toString());
            Mac mac = Mac.getInstance(macSignature);
            mac.init(new SecretKeySpec(macKey.getBytes(StandardCharsets.UTF_8), macSignature));
            byte[] bytes = mac.doFinal(fullEncodedUrl.getBytes(StandardCharsets.UTF_8));
            signature = this.encode(new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])bytes), StandardCharsets.UTF_8).replace("\r\n", ""));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new NetSuiteException(NetSuiteErrorType.ERROR_FAULT, e);
        }
        return String.format("OAuth oauth_nonce=\"%s\", oauth_signature=\"%s\", oauth_token=\"%s\", oauth_consumer_key=\"%s\", oauth_timestamp=\"%s\", oauth_signature_method=\"%s\", oauth_version=\"1.0\", realm=\"%s\"", nonce, signature, this.connectionParameters.getTokenId(), this.connectionParameters.getConsumerKey(), timestamp, this.connectionParameters.getSignatureAlgorithm(), this.connectionParameters.getAccount());
    }

    public static String generateNonceWithTimestamp(long timestampSeconds) {
        byte[] nonceBytes = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(nonceBytes);
        String nonce = Base64.getEncoder().encodeToString(nonceBytes);
        nonce = nonce.replaceAll("\\W", "");
        nonce = nonce + String.valueOf(timestampSeconds);
        return nonce;
    }

    private String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, UTF_8);
    }

    private boolean isDate(String value) {
        return value.matches("\\d{1,2}(\\/|-|.)\\d{1,2}(\\/|-|.)\\d{2,4}") || value.matches("\\d{2,4}(\\/|-|.)\\d{1,2}(\\/|-|.)\\d{1,2}");
    }
}

