/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtils.class);
    private static final String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
    private static final String DISALLOW_DOCTYPE_DECL_FEATURE = "disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";

    private XmlUtils() {
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            logger.trace(String.format("Unable to set feature %s on DocumentBuilderFactory.Trying with feature %s", DISALLOW_DOCTYPE_DECL_FEATURE, EXTERNAL_GENERAL_ENTITIES), (Throwable)e);
            try {
                factory.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            }
            catch (ParserConfigurationException e1) {
                logger.trace(String.format("Unable to set feature %s in DocumentBuilderFactory", EXTERNAL_GENERAL_ENTITIES), (Throwable)e1);
            }
        }
        return factory;
    }
}

