/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.error.exception;

import com.mulesoft.connector.netsuite.extension.internal.error.ErrorContent;
import com.mulesoft.connector.netsuite.extension.internal.error.NetSuiteErrorType;
import java.util.Optional;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class NetSuiteException
extends ModuleException
implements ErrorMessageAwareException {
    private static final long serialVersionUID = -7402816091328386196L;
    private final Message message;
    private static final String MESSAGE_FORMAT = "%s: %s";

    public NetSuiteException(ErrorTypeDefinition code, Throwable cause) {
        super(code, cause);
        this.message = this.buildErrorMessage(cause.getMessage(), (ErrorTypeDefinition<NetSuiteErrorType>)code);
    }

    public NetSuiteException(String message, ErrorTypeDefinition code) {
        super(String.format(MESSAGE_FORMAT, code, message), code);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<NetSuiteErrorType>)code);
    }

    public NetSuiteException(String message, ErrorTypeDefinition code, Throwable cause) {
        super(String.format(MESSAGE_FORMAT, code, message), code, cause);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<NetSuiteErrorType>)code);
    }

    public Message getErrorMessage() {
        return Optional.ofNullable(this.message).orElse(null);
    }

    private Message buildErrorMessage(String message, ErrorTypeDefinition<NetSuiteErrorType> code) {
        return Message.builder().payload(new TypedValue((Object)new ErrorContent(code.getType(), message), DataType.OBJECT)).build();
    }
}

