/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonWrapper {
    private Gson gson = this.getGsonInstance();

    public String parseString(String input) {
        return (String)this.gson.fromJson(input, String.class);
    }

    public List<Map<String, Object>> parseListMap(String input) {
        Map eachMap;
        ArrayList<Map<String, Object>> listAnswers = new ArrayList<Map<String, Object>>();
        Object[] objectArray = null;
        Map objectMap = null;
        try {
            objectArray = this.parseArray(input);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            objectMap = this.parseMap(input);
        }
        if (objectArray != null) {
            for (Object eachObject : objectArray) {
                eachMap = (Map)eachObject;
                listAnswers.add(eachMap);
            }
        }
        if (objectMap != null) {
            eachMap = objectMap;
            listAnswers.add(eachMap);
        }
        return listAnswers;
    }

    private Object[] parseArray(String input) {
        return (Object[])this.gson.fromJson(input, Object[].class);
    }

    private Map<String, Object> parseMap(String input) {
        return (Map)new Gson().fromJson(input, Map.class);
    }

    private Gson getGsonInstance() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        JsonDeserializer deserializer = (jsonElement, type, jsonDeserializationContext) -> {
            HashMap<String, JsonElement> answer = new HashMap<String, JsonElement>();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Set keySets = jsonObject.keySet();
            for (String eachKey : keySets) {
                Object eachValue = jsonObject.get(eachKey);
                eachValue = eachValue.toString().replace("\"", "");
                answer.put(eachKey, (JsonElement)eachValue);
            }
            return answer;
        };
        gsonBuilder.registerTypeAdapter(Map.class, (Object)deserializer);
        return gsonBuilder.create();
    }
}

