/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.extension.internal.connection.provider;

import com.mulesoft.connector.netsuite.extension.internal.connection.provider.config.AdvancedConfig;
import com.mulesoft.connector.netsuite.extension.internal.connection.provider.config.ProxyConfiguration;
import com.mulesoft.connector.netsuite.extension.internal.error.NetSuiteErrorType;
import com.mulesoft.connector.netsuite.extension.internal.error.exception.NetSuiteException;
import com.mulesoft.connector.netsuite.extension.internal.util.XmlUtils;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.inject.Inject;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.w3c.dom.Document;

public abstract class NetSuiteAbstractRestletConnectionProvider<C extends ConnectorConnection>
implements PoolingConnectionProvider<C>,
ConnectorConnectionProvider<C>,
CachedConnectionProvider<C>,
Initialisable,
Disposable {
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @ParameterGroup(name="Advanced")
    @NullSafe
    protected AdvancedConfig advancedConfig;
    @ParameterGroup(name="Proxy")
    @NullSafe
    private ProxyConfiguration proxyConfiguration;
    private HttpClient httpClient;
    private final Function<String, String> endpointRetriever;

    public NetSuiteAbstractRestletConnectionProvider(Function<String, String> endpointRetriever) {
        this.endpointRetriever = endpointRetriever;
    }

    public void initialise() throws InitialisationException {
        try {
            LifecycleUtils.initialiseIfNeeded((Object)this.advancedConfig.getTlsContext());
            this.httpClient = this.createHttpClient(this.proxyConfiguration);
            this.httpClient.start();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void dispose() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    public C connect() throws ConnectionException {
        try {
            String endpoint = this.advancedConfig.getEndpoint();
            if (!Optional.ofNullable(endpoint).isPresent()) {
                HttpResponse response = this.getDataCenterUrls(this.getAccount());
                XPathFactory xPathfactory = XPathFactory.newInstance();
                Document resp = XmlUtils.getDocumentBuilderFactory().newDocumentBuilder().parse(response.getEntity().getContent());
                boolean isSuccess = Boolean.parseBoolean(xPathfactory.newXPath().compile("/Envelope/Body/getDataCenterUrlsResponse/getDataCenterUrlsResult/status/@isSuccess").evaluate(resp));
                if (isSuccess) {
                    endpoint = this.endpointRetriever.apply(xPathfactory.newXPath().compile("/Envelope/Body/getDataCenterUrlsResponse/getDataCenterUrlsResult/dataCenterUrls/restDomain").evaluate(resp));
                } else {
                    throw new ConnectionException(String.format("Cannot dynamically resolve URLs for account '%s'. Make sure to provide a valid Account ID. If you are using a Sandbox, you have to explicitly declare the endpoints in the Global Configuration. Dynamic discovery can only be performed for Production accounts.", this.getAccount()));
                }
            }
            return this.connect(this.httpClient, endpoint);
        }
        catch (Exception e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    private HttpResponse getDataCenterUrls(String account) throws IOException, TimeoutException {
        InputStream requestBody = Thread.currentThread().getContextClassLoader().getResourceAsStream("getDataCenterUrlsRequestTemplate.xml");
        String requestBodyString = IOUtils.toString((InputStream)requestBody, (Charset)StandardCharsets.UTF_8).replace("${account}", account).replace("${api_version}", "2019_1");
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri("https://webservices.netsuite.com/services/NetSuitePort_2020_2").addHeader("SOAPAction", "getDataCenterUrls")).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(requestBodyString.getBytes(StandardCharsets.UTF_8))))).build();
        HttpResponse httpResponse = this.httpClient.send(request, this.advancedConfig.getConnectionTimeoutInMillis().intValue(), true, null);
        return httpResponse;
    }

    protected abstract C connect(HttpClient var1, String var2) throws ConnectionException;

    public void disconnect(C connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(C connection) {
        try {
            Integer validateResult = this.getDataCenterUrls(this.getAccount()).getStatusCode();
            if (validateResult.intValue() == HttpConstants.HttpStatus.OK.getStatusCode()) {
                return ConnectionValidationResult.success();
            }
            String message = "Connection validation failed. Expected status code 200 but was " + validateResult;
            return ConnectionValidationResult.failure((String)message, (Exception)((Object)new NetSuiteException(message, NetSuiteErrorType.CONNECTIVITY)));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    protected abstract String getAccount();

    private HttpClient createHttpClient(ProxyConfig httpServiceProxyConfig) {
        ProxyConfig httpProxyConfigToSet = null;
        if (httpServiceProxyConfig.getHost() != null) {
            httpProxyConfigToSet = httpServiceProxyConfig;
        }
        TcpClientSocketPropertiesBuilder builder = TcpClientSocketProperties.builder().connectionTimeout(this.advancedConfig.getConnectionTimeoutInMillis()).clientTimeout(this.advancedConfig.getReadTimeoutInMillis());
        return this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setConnectionIdleTimeout(this.advancedConfig.getConnectionTimeoutInMillis().intValue()).setTlsContextFactory(this.advancedConfig.getTlsContext()).setProxyConfig(httpProxyConfigToSet).setClientSocketProperties(builder.build()).setName(this.configName).build());
    }
}

