/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif;

import com.mulesoft.connectors.rosettanet.extension.internal.MimeData;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.Supplier;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeUtils {
    public static final String[] EXCLUDED_HEADERS = new String[]{"Message-ID", "MIME-Version", "Content-Type"};
    private static final Logger logger = LoggerFactory.getLogger(MimeUtils.class);

    private MimeUtils() {
    }

    public static <T> T runJavaMail(Supplier<T> body) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MimeUtils.class.getClassLoader());
            T t = body.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static MimeMultipart getMimeContent(byte[] data) {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        return MimeUtils.runJavaMail(() -> {
            try {
                MimeMessage mime = new MimeMessage(session, (InputStream)new ByteArrayInputStream(data));
                if (mime.isMimeType("multipart/related")) {
                    return (MimeMultipart)mime.getContent();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting to MIME message", e);
            }
            throw new RuntimeException("MIME message is not in multipart form");
        });
    }

    public static MimeMultipart getUnsigned(MimeMultipart msg) throws Exception {
        if (msg.getContentType().contains("multipart/related")) {
            return MimeUtils.runJavaMail(() -> {
                try {
                    BodyPart part;
                    if (msg.getCount() == 1 && (part = msg.getBodyPart(0)).isMimeType("multipart/related")) {
                        return (MimeMultipart)part.getContent();
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error extracting unsigned MIME content", e);
                }
            });
        }
        return null;
    }

    private static InputStream getMessagePart(String location, MimeMultipart multi) {
        try {
            for (int i = 0; i < multi.getCount(); ++i) {
                BodyPart bp = multi.getBodyPart(i);
                String[] conlocs = bp.getHeader("Content-Location");
                if (conlocs == null) continue;
                for (String conloc : conlocs) {
                    if (!location.equalsIgnoreCase(conloc)) continue;
                    return bp.getInputStream();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error extracting required message part at location " + location, (Throwable)e);
        }
        return null;
    }

    public static InputStream getPreambleHeader(MimeMultipart multi) {
        return MimeUtils.getMessagePart("RN-Preamble", multi);
    }

    public static InputStream getDeliveryHeader(MimeMultipart multi) {
        return MimeUtils.getMessagePart("RN-Delivery-Header", multi);
    }

    public static InputStream getServiceHeader(MimeMultipart multi) {
        return MimeUtils.getMessagePart("RN-Service-Header", multi);
    }

    public static InputStream getServiceContent(MimeMultipart multi) {
        return MimeUtils.getMessagePart("RN-Service-Content", multi);
    }

    public static MimeData buildMimeData(boolean sign, MimeMultipart multip) {
        return MimeUtils.runJavaMail(() -> {
            try {
                Properties props = System.getProperties();
                Session session = Session.getDefaultInstance((Properties)props, null);
                MimeMessage msg = new MimeMessage(session);
                MimeMultipart outer = new MimeMultipart();
                MimeBodyPart body = new MimeBodyPart();
                body.setContent((Multipart)multip);
                outer.addBodyPart((BodyPart)body);
                outer.setSubType("related");
                msg.setContent((Multipart)outer);
                msg.removeHeader("Message-ID");
                msg.saveChanges();
                Enumeration henum = msg.getAllHeaders();
                ArrayList<String> headers = new ArrayList<String>();
                ArrayList<String> excludes = new ArrayList<String>();
                excludes.add("Message-ID");
                while (henum.hasMoreElements()) {
                    Header header = (Header)henum.nextElement();
                    if ("content-type".equals(header.getName().toLowerCase())) {
                        StringBuilder builder = new StringBuilder(header.getValue());
                        int offset = header.getValue().indexOf(59);
                        if (offset > 0) {
                            String type = sign ? "; type=\"multipart/signed\"" : "; type=\"multipart/related\"";
                            builder.insert(offset, type);
                        }
                        headers.add(header.getName());
                        headers.add(builder.toString());
                    } else {
                        headers.add(header.getName());
                        headers.add(header.getValue());
                    }
                    excludes.add(header.getName());
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)bos, excludes.toArray(new String[0]));
                MimeData data = new MimeData();
                data.setBody(bos.toByteArray());
                data.setHeaders(headers.toArray(new String[0]));
                return data;
            }
            catch (Exception e) {
                logger.error("Failed MIME data conversion for sending", (Throwable)e);
                throw new MimeUtilException("Failed MIME data conversion for sending", e);
            }
        });
    }
}

