/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms.bc;

import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.shaded.cms.SignerInformationVerifier;
import org.bouncycastle.shaded.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.shaded.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.DigestCalculatorProvider;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.bc.BcECContentVerifierProviderBuilder;

public class BcECSignerInfoVerifierBuilder {
    private BcECContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcECSignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcECContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

