/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.pqc.crypto.lms;

import java.io.IOException;
import org.bouncycastle.shaded.crypto.CipherParameters;
import org.bouncycastle.shaded.pqc.crypto.MessageSigner;
import org.bouncycastle.shaded.pqc.crypto.lms.LMS;
import org.bouncycastle.shaded.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.shaded.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.shaded.pqc.crypto.lms.LMSSignature;

public class LMSSigner
implements MessageSigner {
    private LMSPrivateKeyParameters privKey;
    private LMSPublicKeyParameters pubKey;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            this.privKey = (LMSPrivateKeyParameters)cipherParameters;
        } else {
            this.pubKey = (LMSPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        try {
            return LMS.generateSign(this.privKey, byArray).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature: " + iOException.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            return LMS.verifySignature(this.pubKey, LMSSignature.getInstance(byArray2), byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to decode signature: " + iOException.getMessage());
        }
    }
}

