/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.crypto.signature;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Supplier;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.shaded.mail.smime.SMIMESigned;

public class MimeSignedUtils {
    public static SMIMESigned getSigned(MimeMultipart msg) {
        if (msg.getContentType().contains("multipart/signed")) {
            return MimeSignedUtils.runJavaMail(() -> {
                try {
                    BodyPart body = msg.getBodyPart(0);
                    return new SMIMESigned((MimeMultipart)body.getContent());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error converting to MIME message", e);
                }
            });
        }
        return null;
    }

    public static MimeMultipart getSignedContent(MimeMultipart mimemp) {
        MimeBodyPart body = MimeSignedUtils.getSigned(mimemp).getContent();
        try {
            if (body.isMimeType("multipart/related")) {
                return (MimeMultipart)body.getContent();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting signed MIME content", e);
        }
        throw new RuntimeException("Signed message content is not in multipart form");
    }

    private static <T> T runJavaMail(Supplier<T> body) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MimeSignedUtils.class.getClassLoader());
            T t = body.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    static {
        final MailcapCommandMap var0 = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        var0.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.pkcs7_signature");
        var0.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.pkcs7_mime");
        var0.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.x_pkcs7_signature");
        var0.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.x_pkcs7_mime");
        var0.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.multipart_signed");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap.setDefaultCommandMap((CommandMap)var0);
                return null;
            }
        });
    }
}

