/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.crypto.signature;

import com.mulesoft.connectors.rosettanet.extension.crypto.signature.CryptoSigner;
import com.mulesoft.connectors.rosettanet.extension.crypto.signature.MimeSignedUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.utils.RosettaNetBouncyCastleProvider;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.shaded.cert.jcajce.JcaCertStore;
import org.bouncycastle.shaded.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.shaded.cms.SignerInformation;
import org.bouncycastle.shaded.cms.SignerInformationStore;
import org.bouncycastle.shaded.cms.SignerInformationVerifier;
import org.bouncycastle.shaded.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.shaded.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.shaded.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.shaded.mail.smime.SMIMESigned;
import org.bouncycastle.shaded.mail.smime.SMIMESignedGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartCryptoSigner
implements CryptoSigner {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartCryptoSigner.class);
    private KeyStore keyStore;
    private String signAlias;
    private char[] keyPass;
    private JcaX509CertSelectorConverter selectorConverter = new JcaX509CertSelectorConverter();

    public MultiPartCryptoSigner(KeyStore keyStore, String signAlias, char[] keyPass) {
        this.keyStore = keyStore;
        this.signAlias = signAlias;
        this.keyPass = keyPass;
    }

    public MultiPartCryptoSigner(KeyStore certificateStore) {
        this(certificateStore, null, null);
    }

    @Override
    public MimeMultipart sign(MimeMultipart mp) {
        try {
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(this.signAlias);
            PrivateKey key = (PrivateKey)this.keyStore.getKey(this.signAlias, this.keyPass);
            SMIMESignedGenerator gen = new SMIMESignedGenerator();
            gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(RosettaNetBouncyCastleProvider.getBouncyCastleProvider()).build("SHA1withRSA", key, cert));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(cert);
            JcaCertStore store = new JcaCertStore(certList);
            gen.addCertificates(store);
            MimeBodyPart m = new MimeBodyPart();
            m.setContent((Multipart)mp);
            return gen.generate(m);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating message signature", e);
        }
    }

    @Override
    public boolean isSigned(MimeMultipart mimemp) {
        return MimeSignedUtils.getSigned(mimemp) != null;
    }

    @Override
    public MimeMultipart getSignedContent(MimeMultipart mimemp) {
        return MimeSignedUtils.getSignedContent(mimemp);
    }

    @Override
    public List<ValidationInformation> validateSignature(MimeMultipart mimemp) {
        SMIMESigned signed = MimeSignedUtils.getSigned(mimemp);
        return MimeUtils.runJavaMail(() -> {
            SignerInformationStore signers = signed.getSignerInfos();
            Iterator<SignerInformation> it = signers.getSigners().iterator();
            JcaCertStoreBuilder builder = new JcaCertStoreBuilder();
            builder.addCertificates(signed.getCertificates());
            builder.setProvider(RosettaNetBouncyCastleProvider.getBouncyCastleProvider());
            ArrayList<ValidationInformation> infos = new ArrayList<ValidationInformation>();
            try {
                CertStore certs = builder.build();
                while (it.hasNext()) {
                    SignerInformation signer = it.next();
                    X509CertSelector selector = this.selectorConverter.getCertSelector(signer.getSID());
                    Collection<? extends Certificate> matches = certs.getCertificates(selector);
                    for (X509Certificate x509Certificate : matches) {
                        if (!this.verifySigningCertificate(x509Certificate, signer)) continue;
                        Enumeration<String> aliases = this.keyStore.aliases();
                        while (aliases.hasMoreElements()) {
                            String alias = aliases.nextElement();
                            Certificate comp = this.keyStore.getCertificate(alias);
                            if (!comp.equals(x509Certificate)) continue;
                            logger.debug("Found certificate in keystore with alias " + alias);
                            infos.add(new ValidationInformation(signer.getContentDigest(), alias));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in message signature verification", e);
            }
            return infos;
        });
    }

    private boolean verifySigningCertificate(X509Certificate cert, SignerInformation signer) throws Exception {
        String principal = cert.getSubjectDN().getName();
        logger.debug("Checking signature with certificate for " + principal + " from truststore");
        JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
        builder.setProvider(RosettaNetBouncyCastleProvider.getBouncyCastleProvider());
        SignerInformationVerifier verifier = builder.build(cert.getPublicKey());
        if (signer.verify(verifier)) {
            logger.debug("Signature validation succeeded with certificate for " + principal);
            return true;
        }
        logger.debug("Signature validation failed with certificate for " + principal);
        return false;
    }

    static {
        final MailcapCommandMap var0 = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        var0.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.pkcs7_signature");
        var0.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.pkcs7_mime");
        var0.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.x_pkcs7_signature");
        var0.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.x_pkcs7_mime");
        var0.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.shaded.mail.smime.handlers.multipart_signed");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap.setDefaultCommandMap((CommandMap)var0);
                return null;
            }
        });
    }

    public static class ValidationInformation {
        private final byte[] digestValue;
        private final String certificateAlias;

        private ValidationInformation(byte[] digest, String alias) {
            this.digestValue = digest;
            this.certificateAlias = alias;
        }

        public byte[] getDigestValue() {
            return this.digestValue;
        }

        public String getCertificateAlias() {
            return this.certificateAlias;
        }
    }
}

