/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.utils;

import com.mulesoft.connectors.rosettanet.extension.internal.utils.FipsUtils;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaNetBouncyCastleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RosettaNetBouncyCastleProvider.class);
    private static RosettaNetBouncyCastleProvider instance = null;
    private Provider bouncyCastleProvider;

    private RosettaNetBouncyCastleProvider() {
        if (FipsUtils.isFipsMode()) {
            LOGGER.info("Fips mode detected. Using BCFIPS provider for RosettaNet");
            this.bouncyCastleProvider = FipsUtils.getFipsProvider();
        } else {
            LOGGER.info("Initializing Provider.");
            this.bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider(this.bouncyCastleProvider);
        }
    }

    public static Provider getBouncyCastleProvider() {
        if (instance == null) {
            instance = new RosettaNetBouncyCastleProvider();
        }
        return RosettaNetBouncyCastleProvider.instance.bouncyCastleProvider;
    }
}

