/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.generators;

import java.security.SecureRandom;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.shaded.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.shaded.crypto.CryptoServicePurpose;
import org.bouncycastle.shaded.crypto.CryptoServicesRegistrar;
import org.bouncycastle.shaded.crypto.KeyGenerationParameters;
import org.bouncycastle.shaded.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.shaded.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.shaded.crypto.params.X448PublicKeyParameters;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

